/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.openide.ErrorManager;
import org.openide.util.Utilities;

public class CustomClassLoader
extends URLClassLoader {
    private Map<String, File> package2File = new HashMap<String, File>();
    private static final Logger logger = Logger.getLogger(CustomClassLoader.class.getName());

    public CustomClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Initializing Custom Classloader with classpath : ");
            for (URL url : urls) {
                logger.info(url.toExternalForm());
            }
        }
    }

    protected Class loadClass(String name, boolean b) throws ClassNotFoundException {
        if (name == null) {
            throw new IllegalArgumentException("class name cannot be null");
        }
        Class<?> clazz = this.findLoadedClass(name);
        if (clazz != null) {
            return clazz;
        }
        String packageName = null;
        int lastDotIndex = name.lastIndexOf(46);
        if (lastDotIndex != -1) {
            packageName = name.substring(0, lastDotIndex);
        }
        if (packageName != null && (packageName.startsWith("java") || packageName.startsWith("javax") || packageName.startsWith("com.sun") || packageName.startsWith("org.hibernate") || packageName.startsWith("org.dom4j") || packageName.startsWith("net.sf.cglib") || packageName.startsWith("org.w3c") || packageName.startsWith("antlr") || packageName.startsWith("org.objectweb.asm") || packageName.startsWith("org.apache.commons.collections") || packageName.startsWith("net.sf.ehcache") || packageName.startsWith("org.netbeans"))) {
            clazz = super.loadClass(name, b);
        }
        if (clazz != null) {
            return clazz;
        }
        if (packageName != null && packageName.startsWith("org.apache.log4j")) {
            throw new ClassNotFoundException("Log4J is forbidden");
        }
        int dotIndex = name.indexOf(46);
        String separator = File.separator;
        if (separator.equals("\\")) {
            separator = "\\\\";
        }
        String fileName = dotIndex != -1 ? name.replaceAll("\\.", separator) + ".class" : name + ".class";
        Class loadedClass = null;
        try (InputStream is = this.getLocalResourceAsStream(packageName, fileName);){
            if (is != null) {
                loadedClass = this.loadClass(name, is);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (loadedClass != null) {
            return loadedClass;
        }
        return super.loadClass(name, b);
    }

    private Class loadClass(String className, InputStream is) {
        Class<?> clazz;
        BufferedInputStream bis = new BufferedInputStream(is);
        try {
            int readBytes;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            byte[] bytes = new byte[5120];
            while ((readBytes = bis.read(bytes)) != -1) {
                os.write(bytes, 0, readBytes);
            }
            byte[] b = os.toByteArray();
            clazz = this.defineClass(className, b, 0, b.length);
        }
        catch (Throwable throwable) {
            try {
                try {
                    bis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ClassFormatError ex) {
                ErrorManager.getDefault().notify(1, ex);
                return null;
            }
        }
        bis.close();
        return clazz;
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codeSource) {
        Permissions perms = new Permissions();
        perms.add(new AllPermission());
        perms.setReadOnly();
        return perms;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private URL getLocalResource(String packageName, String name) {
        File preferred = null;
        if (packageName != null) {
            preferred = this.package2File.get(packageName);
        }
        ArrayList<File> files = new ArrayList<File>();
        if (preferred != null) {
            files.add(preferred);
        }
        Iterator iterator = files.iterator();
        while (iterator.hasNext()) {
            File entry = (File)iterator.next();
            if (entry.isDirectory() && entry.exists()) {
                File f = new File(entry, name);
                if (!f.exists()) continue;
                try {
                    this.package2File.put(packageName, entry);
                    return Utilities.toURI((File)f).toURL();
                }
                catch (MalformedURLException ex) {
                    continue;
                }
            }
            if (!entry.isFile() || !entry.exists()) continue;
            try (ZipFile zf = new ZipFile(entry);){
                ZipEntry zipEntry = zf.getEntry(name = name.replaceAll("\\\\", "/"));
                if (zipEntry == null) continue;
                Object url = entry.getAbsolutePath().replaceAll("\\\\", "/");
                if (!((String)url).startsWith("/")) {
                    url = "/" + (String)url;
                }
                URL r = new URI("jar:file://" + (String)url + "!/" + name).toURL();
                this.package2File.put(packageName, entry);
                URL uRL = r;
                return uRL;
            }
            catch (ZipException zipException) {
            }
            catch (IOException | URISyntaxException exception) {}
        }
        return null;
    }

    private InputStream getLocalResourceAsStream(String packageName, String name) {
        URL res = this.getLocalResource(packageName, name);
        if (res == null) {
            return null;
        }
        try {
            return res.openStream();
        }
        catch (IOException ex) {
            return null;
        }
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        InputStream is = this.getLocalResourceAsStream(null, name);
        return is != null ? is : super.getResourceAsStream(name);
    }
}

